<?php

namespace Database\Seeders;

use App\Models\Priority;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PrioritySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('priorities')->truncate();
        $priories = ['Low', 'Medium', 'High', 'Very Urgent'];
        foreach ($priories as $priority) {
            DB::table('priorities')->insert([
                'name' => $priority,
            ]);
        }
    }
}
